import UIKit

class CustomView: UIView
{
    @IBOutlet var contentView: UIView!
    
    @IBOutlet weak var topLabel: UILabel!
    
    init(inpWidth: CGFloat)
    {
        let heightToWidth : CGFloat = 1000.0 / 375.0
        let newHeight : CGFloat = heightToWidth * inpWidth
        
        let newFrame = CGRect(x: 0,
                              y: 0,
                              width: inpWidth,
                              height: newHeight)
        super.init(frame: newFrame)
        
        Bundle.main.loadNibNamed("CustomView",
                                 owner: self,
                                 options: nil)
        
        addSubview(contentView) // add the content from the XIB file
        contentView.frame = self.bounds
        
        
    }
    
    
    
    @IBAction func buttonTapped(_ sender: Any)
    {
        print("Button Tapped")
    }
    
    
    
    
    required init?(coder aDecoder: NSCoder)
    {
        fatalError("init(coder:) has not been implemented")
    }
}
